#pragma once
#include "afxwin.h"
#include "afxcmn.h"
#include"MainSheet.h"
#include "CardFront.h"
#include "CardBack.h"

typedef struct tag_TABLE_ENTRY
{
	LPTSTR	Text;
	int		Reference;
} TABLE_ENTRY;

// CPrintDemo dialog

class CPrintDemo : public CPropertyPage
{
	DECLARE_DYNAMIC(CPrintDemo)

public:
	static const int MaxColours = 8;
	static const TABLE_ENTRY ColourTable[MaxColours + 1];	//Extra entry for 'Transparent'
	static const int BlackEntry = 7;

	static const int MaxShapes = 5;
	static const TABLE_ENTRY ShapeTable[MaxShapes];

public:
	CPrintDemo();
	virtual ~CPrintDemo();
	virtual BOOL OnInitDialog();

// Dialog Data
	enum { IDD = IDD_PRINTDEMO };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()

public:
	afx_msg void OnBnClickedBtnPrint();
	afx_msg void OnBnClickedFrontCheck();
	afx_msg void OnBnClickedBackCheck();
	afx_msg void OnTcnSelchangeTab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnTcnSelchangingTab(NMHDR *pNMHDR, LRESULT *pResult);
	afx_msg void OnBnClickedPrinterPrefs();
	afx_msg void OnBnClickedGdiprint();

	void EnableGetSetControls_Front(BOOL bControl);

	void GDIPrintText(HDC        hDC, 
					  CComboBox *pencolour,
					  CEdit     *size,
					  CButton   *bold,
					  CButton   *italic,
					  CButton   *underline,
					  CButton   *strikeout,
					  CEdit     *textX,
					  CEdit     *textY,
					  CEdit     *text);
	void GDIPrintShape(HDC       hDC, 
					   CComboBox *shape,
					   CComboBox *pen,
					   CEdit     *penwidth,
					   CComboBox *brush,
					   CEdit     *left,
					   CEdit     *top,
					   CEdit     *right,
					   CEdit     *bottom);
	void GDIPrintLine(HDC        hDC, 
					  CComboBox *pencolour,
					  CEdit     *penwidth,
					  CEdit     *beginX,
					  CEdit     *beginY,
					  CEdit     *finishX,
					  CEdit     *finishY);
	void GDIPrintImage(HDC      hDC, 
					   CString  filename,
					   CEdit   *left,
					   CEdit   *top,
					   CEdit   *P1,
					   CEdit   *P2);
	void PrintUsingGDI();

	CMainSheet *Parent;
	HDC PrinterDC;
	CString DeviceName;

	CButton CardFrontTick;
	CButton CardBackTick;
	CButton PrintDemoBtn;
	CTabCtrl CardTab;
	CCardFront *CardFront;
	CCardBack  *CardBack;
	CButton GDIPrint;
};
